(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        define([ 'module', 'angular' ], function (module, angular) {
            module.exports = factory(angular);
        });
    } else if (typeof module === 'object') {
        module.exports = factory(require('angular'));
    } else {
        if (!root.mp) {
            root.mp = {};
        }

        root.mp.escAction = factory(root.angular);
    }
}(this, function (angular) {
    'use strict';

    return angular.module('module.textareaParser', ['dnd','ngDraggable'])
        .factory('uuid', function() {
            var svc = {
                new: function() {
                    function _p8(s) {
                        var p = (Math.random().toString(16)+"000000000").substr(2,8);
                        return s ? "-" + p.substr(0,4) + "-" + p.substr(4,4) : p ;
                    }
                    return _p8() + _p8(true) + _p8(true) + _p8();
                },

                empty: function() {
                    return '00000000-0000-0000-0000-000000000000';
                },
                range: function(start, end) {
                    var arr  = [];
                    for (let i = start; i <= end; i++) {
                        arr.push(i);
                    }
                    return arr;
                }
            };
            return svc;
        })
        .controller('modalInstanceFormCtrl', function ($scope, $uibModalInstance) {
            $scope.model = {};
            $scope.textareaParserSubmit = function(){
                if ($scope.parserForm.$valid) {
                    $uibModalInstance.close($scope.model);
                } else {
                    //$scope.showValidation = true;
                }
            }
            $scope.cancel = function () {
                $uibModalInstance.dismiss('cancel');
            };

            $scope.getError = function (error) {
                if (angular.isDefined(error)) {
                    //объект который здесь ожидается получить - error но он будет сформирован только тогда когда будет допущена хотя бы одна ошибка валидации,
                    //а пока их нет он undefined и для того чтобы избежать ошибки нужно использовать проверку
                    if (error.required) {
                        return "Поле не долно быть пустым";
                    } else if (error.minlength) {
                        return "Минимум десять символов";
                    }
                }
            };
        })
        .controller('parseResultFormCtrl', function ($scope, $uibModalInstance, items, $timeout, uuid) {
            $scope.goods = items;
            $scope.dopFiled = null;
            $scope.cacheElement = 'test';
            $scope.arrLength = [];


            $scope.setCacheElement = function(value){
                $scope.cacheElement = value;
            }

            $scope.setCache = function(value){
                $scope.cacheElement = value;
            }
            $scope.getCache = function(){
                return $scope.cacheElement;
            }

            Math.max.apply(Math, $scope.goods.forEach(function(v, k){
                if(Object.keys(v).length > 3){
                    $scope.arrLength.push(Object.keys(v).length);
                }
            }));
            $scope.dopFiled = Math.max.apply(Math,$scope.arrLength);
            $scope.dopFiled = uuid.range(1, $scope.dopFiled - 3);
            $scope.FormSubmit = function(){
                if ($scope.myForm.$valid) {
                    $uibModalInstance.close($scope.goods);
                } else {
                    //$scope.showValidation = true;
                }
            }

            $scope.addGood = function(){
                $scope.goods.push({})
            }
            $scope.getError = function (error) {
                if (angular.isDefined(error)) {
                    //объект который здесь ожидается получить - error но он будет сформирован только тогда когда будет допущена хотя бы одна ошибка валидации,
                    //а пока их нет он undefined и для того чтобы избежать ошибки нужно использовать проверку
                    if (error.required) {
                        return "Поле не долно быть пустым";
                    } else if (error.minlength) {
                        return "Минимум 3 cимвола";
                    }
                }
            };

            $scope.dropped = function(dragEl, dropEl) { // function referenced by the drop target
                //this is application logic, for the demo we just want to color the grid squares
                //the directive provides a native dom object, wrap with jqlite

                var drop = angular.element(dropEl);
                var drag = angular.element(dragEl);

            }

        })
        .directive('lvlDraggable', ['$rootScope', 'uuid', function ($rootScope, uuid) {
            return {
                restrict: 'EA',
                scope:{
                    model: '=ngModel',
                    cache:'=ngCache',
                    setCacheElement: '&'
                },
                template: '<input  type="text" class="form-control drag-el" ng-model="model">',
                link: function ($scope, el, attrs, controller) {
                    angular.element(el).find('input').attr("draggable", "true");
                    var id = angular.element(el).find('input').attr("id");
                    if (!id) {
                        id = uuid.new()
                        angular.element(el).find('input').attr("id", id);
                    }

                    el.bind("dragstart", function (e) {
                        e.originalEvent.dataTransfer.setData('text', id);
                        angular.element(document.getElementsByClassName('drag-el')).attr('readOnly', true);

                        $rootScope.$emit("LVL-DRAG-START");
                    });


                    el.bind("dragend", function (e) {
                        $rootScope.$emit("LVL-DRAG-END");
                        angular.element(document.getElementsByClassName('drag-el')).attr('readOnly', false);
                        angular.element(e.target).find('input').removeClass('lvl-drag');
                       // $scope.model = $scope.xLvlCache;
                    });
                }
            };
        }])

        .directive('lvlDropTarget', ['$rootScope', 'uuid', function ($rootScope, uuid, $timeout) {
            return {
                restrict: 'EA',
                scope: {
                    model: '=ngModel',
                    cache:'=ngCache',
                    name: '@',
                    onDrop: '&',
                    getCache: '&',
                },
                template: '<input required  type="text" class="form-control" ng-minlength="3"  value="{{model}}"  placeholder="наименование">',
                link: function ($scope, el, attrs, controller) {
                    var id = angular.element(el).find('input').attr("id");
                    if (!id) {
                        id = uuid.new();
                        angular.element(el).attr("id", id);
                    }

                    el.bind("dragover", function (e) {
                        if (e.preventDefault) {
                            e.preventDefault(); // Necessary. Allows us to drop.
                        }
                        e.originalEvent.dataTransfer.dropEffect = 'move';  // See the section on the DataTransfer object.
                        return false;
                    });

                    el.bind("dragenter", function (e) {
                        // this / e.target is the current hover target.
                        angular.element(e.target).addClass('lvl-over');
                    });

                    el.bind("dragleave", function (e) {
                        angular.element(e.target).removeClass('lvl-over');  // this / e.target is previous target element.
                        angular.element(document.getElementsByClassName('lvl-over')).readOnly = true;
                    });

                    el.bind("drop", function (e) {


                        console.log('drop',$scope.model);
                        if (e.preventDefault) {
                            e.preventDefault(); // Necessary. Allows us to drop.
                        }

                        if (e.stopPropagation) {
                            e.stopPropagation(); // Necessary. Allows us to drop.
                        }
                        var data = e.originalEvent.dataTransfer.getData("text");
                        var dest = $(document.getElementById(id)).find('input');
                        var src = $(document.getElementById(data));

                        $scope.model = src.val();
                        src.blur()
                        $scope.onDrop({dragEl: dest, dropEl: src});
                    });

                    $rootScope.$on("LVL-DRAG-START", function () {
                        var el = document.getElementById(id);
                        angular.element(el).find('input').addClass("lvl-target");
                    });

                    $rootScope.$on("LVL-DRAG-END", function () {
                        var el = document.getElementById(id);
                        angular.element(el).find('input').removeClass("lvl-target");
                        angular.element(el).find('input').removeClass("lvl-over");
                        angular.element(el).find('input').blur();
                    });

                    $rootScope.$on("LVL-CHANGE-FIELD", function(){


                    });
                }
            };
        }])
        .directive('textareaParser', function ($timeout, $uibModal) {

            return {
                restrict: 'EA',
                scope:{
                    customSaveResult: '&?',
                    customParser: '&?',
                    parserData: '=?'
                },
                templateUrl:"angular-textarea-parser/angular-textarea-parser.html",
                link: function ($scope, element, $attr) {

                    $scope.data = [];
                    $scope.modalInstanceForm = {};
                    $scope.modalResultForm = {};

                    $scope.open = function () {
                        $scope.modalInstanceForm = $uibModal.open({
                            ariaLabelledBy: 'modal-title',
                            ariaDescribedBy: 'modal-body',
                            controller: 'modalInstanceFormCtrl',
                            templateUrl: 'myModalContent.html',
                            resolve: {
                                items: function () {
                                    console.log('items');
                                }
                            }
                        });
                        $scope.modalInstanceForm.result.then(function (parserForm) {
                            console.log(parserForm);

                            if(typeof $scope.customParser == 'function'){
                                $scope.customParser()()
                            }else{
                                $scope.defaultParser();
                            }

                        }, function (error) {
                            console.log(error);
                        });
                    };

                    $scope.defaultParser = function(){
                        $scope.data = [
                            {
                                name: 'test1',
                                count: 1,
                                price: 100,
                                f1: 121,
                                f2: 1242134,
                                f5: 4435643
                            },
                            {
                                name: 'test2',
                                count: 2,
                                price: 300,
                                f1: 43445,
                                f2:8888
                            },
                        ];

                        $scope.requestServerParser();
                    }

                    $scope.requestServerParser = function(){
                        $timeout(function(){
                            $scope.modalResultForm = $uibModal.open({
                                ariaLabelledBy: 'modal-title',
                                ariaDescribedBy: 'modal-body',
                                controller: 'parseResultFormCtrl',
                                templateUrl: 'parseResultForm.html',
                                size: 'lg',
                                resolve: {
                                    items: function () {
                                        return $scope.data;
                                    }
                                }
                            });

                            $scope.modalResultForm.result.then(
                                function (result) {
                                    if(typeof $scope.customSaveResult == 'function'){
                                        $scope.customSaveResult()(result);
                                    }else{
                                        $scope.defaultSaveResult(result);
                                    }
                                },
                                function (error) {
                                    console.log(error);
                                }
                            );
                        }, 1000);
                    }

                    $scope.defaultSaveResult = function(result){
                        console.log('defaultSaveResult', result);
                    }
                }
            };
    });
}));