<?php
/**
 * Created by PhpStorm.
 * User: anchi
 * Date: 09.12.2019
 * Time: 1:28
 */

namespace core;



class ErrorHandler
{
    public function __construct(){


        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);

        set_exception_handler([$this, 'customErrorHandler']);
    }
    /**
     * @param $e
     */
    public function customErrorHandler($e){
        $this->logErrors($e->getMessage(), $e->getFile(), $e->getLine(), $e->getCode());
        $this->displayError('исключение', $e->getMessage(), $e->getFile(), $e->getLine(), $e->getCode());
    }
    protected function logErrors($message = '', $file = '', $line = '', $code = ''){
        //error_log("[".date('Y-m-d H-i-s')."] Текст ошибки: {$message} | Файл: {$file} | Строка: {$line}\r\n", 3, ROOT.'/tmp/error.log');
    }
    protected function displayError($errno, $errstr, $errfile, $errline, $response = 404){
        http_response_code($response);
        var_dump($errno, $errstr);
    }
}