# Changes in PHPUnit 6.0

All notable changes of the PHPUnit 6.0 release series are documented in this file using the [Keep a CHANGELOG](http://keepachangelog.com/) principles.

## [6.0.0] - 2017-02-03

### Added

* Merged [#2230](https://github.com/sebastianbergmann/phpunit/pull/2230): Add `getExpectedExceptionCode()` and `getExpectedExceptionMessage()`
* Merged [#2344](https://github.com/sebastianbergmann/phpunit/pull/2344): Add support for annotations on traits
* Merged [#2351](https://github.com/sebastianbergmann/phpunit/pull/2351): Allow to filter for multiple test suites
* Added the `PHPUnit\Framework\TestCase::createTestProxy()` method for creating test proxies
* Added the `--dont-report-useless-tests` commandline option
* Added the `--globals-backup` commandline option
* Added `verbatim` attribute to prevent `"true"` and `"false"` from being converted to `true` and `false`, respectively

### Changed

* PHPUnit's units of code are now namespaced
* PHPUnit is now strict about useless tests by default
* The configuration generated using `--generate-configuration` now includes `forceCoversAnnotation="true"`
* Global and super-global variables are no longer backed up before and restored after each test by default
* `PHPUnit\Framework\Assert::fail()` now increments the assertion counter
* `setUpBeforeClass()` is now invoked after all methods annotated with `@beforeClass`
* `setUp()` is now invoked after all methods annotated with `@before`
* Added `addWarning()` method to `PHPUnit\Framework\TestListener` interface
* The logfile format generated using the `--log-junit` option and the `<log type="junit" target="..."/>` configuration directive has been updated to match the [current format used by JUnit](http://llg.cubic.org/docs/junit/). Due to this change you may need to update how your continuous integration server processes test result logfiles generated by PHPUnit.
* The binary PHAR is now binary-only and cannot be used as a library anymore
* Renamed the `PHPUnit_Extensions_PhptTestCase` class to `PHPUnit_Runner_PhptTestCase`
* The `PHPUnit\Framework\TestCase::getMockObjectGenerator()` method is now private
* Merged [#2241](https://github.com/sebastianbergmann/phpunit/pull/2241): Make JSON assertions stricter
* The test runner now exits with `1` (instead of `0`) when all tests pass but there are warnings

### Removed

* Removed `PHPUnit\Framework\TestCase::getMock()` (deprecated in PHPUnit 5.4)
* Removed `PHPUnit\Framework\TestCase::getMockWithoutInvokingTheOriginalConstructor()` (deprecated in PHPUnit 5.4)
* Removed `PHPUnit\Framework\TestCase::setExpectedException()` (deprecated in PHPUnit 5.2)
* Removed `PHPUnit\Framework\TestCase::setExpectedExceptionRegExp()` (deprecated in PHPUnit 5.6)
* Removed `PHPUnit\Framework\TestCase::hasPerformedExpectationsOnOutput()` (deprecated in PHPUnit 4.3)
* Removed the `PHPUnit_Extensions_GroupTestSuite` class
* Removed the `PHPUnit_Extensions_PhptTestSuite` class
* Removed the `PHPUnit_Extensions_RepeatedTest` class
* Removed the `PHPUnit_Extensions_TestDecorator` class
* Removed the `PHPUnit_Extensions_TicketListener` class
* Removed the `PHPUnit_Util_Log_JSON` class
* Removed the `PHPUnit_Util_Log_TAP` class
* Removed the `PHPUnit_Util_Test::getTickets()` method
* Removed the `checkForUnintentionallyCoveredCode` configuration setting (deprecated in PHPUnit 5.2)
* Removed the `--log-json` commandline option (deprecated in PHPUnit 5.7)
* Removed the `--log-tap` and `--tap` commandline options (deprecated in PHPUnit 5.7)
* Removed the `--no-globals-backup` commandline option
* Removed the `--report-useless-tests` commandline option
* Removed the `--self-update` and `--self-upgrade` commandline options (deprecated in PHPUnit 5.7)
* DbUnit is no longer bundled in the PHAR distribution of PHPUnit
* PHPUnit is no longer supported on PHP 5.6

[6.0.0]: https://github.com/sebastianbergmann/phpunit/compare/5.7...6.0.0

